/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2016-2018 Dan "Ducky" Little
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
export const HIGHLIGHT_STYLE = {
  "circle-radius": 4,
  "circle-color": "#ffff00",
  "circle-stroke-color": "#ffff00",
  "line-color": "#ffff00",
  "line-width": 4,
  "fill-color": "#ffff00",
  "fill-opacity": 0.25,
  "line-opacity": 0.25,
};

export const HIGHLIGHT_HOT_STYLE = {
  "circle-radius": 4,
  "circle-color": "#ff0000",
  "circle-stroke-color": "#ff0000",
  "line-color": "#ff0000",
  "line-width": 4,
  "fill-color": "#ff0000",
  "fill-opacity": 0.5,
  "line-opacity": 0.5,
};

export const SELECTION_STYLE = {
  "circle-radius": 4,
  "circle-color": "#8470ff",
  "circle-stroke-color": "#8470ff",
  "line-color": "#fc8d59",
  "line-width": 6,
  "line-opacity": 0.8,
  "fill-color": "#91bfdb",
  "fill-opacity": 0.25,
};

export const EDIT_STYLE = {
  "circle-radius": 10,
  "circle-color": "#d53e4f",
  "circle-stroke-color": "#d53e4f",
  "line-color": "#d53e4f",
  "line-width": 6,
  "line-opacity": 0.8,
  "fill-color": "#d53e4f33",
  "fill-opacity": 0.25,
};

export const EDIT_LAYER_NAME = "edit-temp";

export const DEFAULT_RESULTS_CONFIG = {
  showBufferAll: false,
  showZoomToAll: true,
  showLayerCount: true,
  showFeatureCount: true,
  maxBufferFeatures: 100,
};

export const DRAW_TOOLS = [
  "draw-point",
  "draw-polygon",
  "draw-line",
  "draw-modify",
  "draw-remove",
  "draw-edit",
];
