/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2016-2022 Dan "Ducky" Little
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
import React from "react";

const makeJumpy = (idx) => ({
  animationDuration: "1.0s",
  animationDelay: `${idx * 100}ms`,
  animationName: "jumparound",
  animationIterationCount: "infinite",
});

const Logo = ({ logoDark }) => (
  <svg
    version="1.1"
    id="Layer_1"
    x="0px"
    y="0px"
    overflow="visible"
    width="250px"
    height="90px"
    viewBox="0 0 250 71.875"
  >
    <g>
      <path
        style={makeJumpy(0)}
        fill={logoDark}
        d="M27.2,42.515h11.027c2.374,2.946,3.562,6.051,3.562,9.319c0,3.799-1.392,6.99-4.174,9.573
            c-2.784,2.583-6.208,3.875-10.273,3.875c-5.28,0-9.764-2.003-13.449-6.013c-3.686-4.007-5.528-8.89-5.528-14.645
            c0-5.774,1.876-10.581,5.628-14.418c3.751-3.836,8.439-5.755,14.062-5.755c1.918,0,4.046,0.389,6.382,1.168v11.567
            c-1.823-0.854-3.485-1.282-4.986-1.282c-2.717,0-4.935,0.846-6.654,2.536c-1.719,1.692-2.578,3.885-2.578,6.583
            c0,2.754,0.797,4.939,2.394,6.553c1.595,1.616,3.751,2.423,6.468,2.423c1.729,0,2.593-0.504,2.593-1.509
            c0-0.761-0.57-1.142-1.709-1.142H27.2V42.515z"
      />
      <path
        style={makeJumpy(1)}
        fill={logoDark}
        d="M69.531,51.834H53.375c-0.247-0.816-0.37-1.567-0.37-2.252c0-0.948,0.171-1.881,0.512-2.792h5.414
            c-0.38-2.108-1.566-3.163-3.562-3.163c-1.33,0-2.412,0.565-3.248,1.695c-0.836,1.131-1.254,2.579-1.254,4.346
            c0,1.844,0.403,3.334,1.21,4.474c0.808,1.14,1.867,1.709,3.178,1.709c1.063,0,2.089-0.531,3.076-1.595l6.07,7.294
            c-2.831,2.222-5.974,3.333-9.431,3.333c-4.218,0-7.76-1.414-10.628-4.246c-2.869-2.829-4.302-6.333-4.302-10.514
            c0-4.16,1.449-7.674,4.346-10.542c2.896-2.867,6.453-4.303,10.67-4.303c4.123,0,7.584,1.4,10.386,4.202
            c2.802,2.804,4.203,6.256,4.203,10.358C69.645,50.256,69.606,50.922,69.531,51.834z"
      />
      <path
        style={makeJumpy(2)}
        fill={logoDark}
        d="M83.34,35.307c4.027,0,7.479,1.447,10.357,4.346c2.877,2.896,4.316,6.368,4.316,10.414
            c0,4.104-1.458,7.599-4.374,10.486c-2.916,2.887-6.435,4.33-10.556,4.33c-4.123,0-7.646-1.448-10.572-4.345
            c-2.924-2.896-4.388-6.387-4.388-10.472c0-4.16,1.463-7.66,4.388-10.499C75.438,36.728,79.047,35.307,83.34,35.307z M83.056,45.821
            c-1.141,0-2.11,0.413-2.908,1.239c-0.798,0.827-1.196,1.839-1.196,3.036c0,1.176,0.404,2.183,1.211,3.019
            c0.807,0.836,1.771,1.254,2.893,1.254c1.139,0,2.112-0.418,2.919-1.254c0.808-0.836,1.212-1.843,1.212-3.019
            c0-1.197-0.399-2.209-1.197-3.036C85.193,46.234,84.213,45.821,83.056,45.821z"
      />
      <path
        style={makeJumpy(3)}
        fill="#6DBE45"
        d="M98.375,64.314V36.275c0-3.475,1.055-6.316,3.164-8.519c2.108-2.204,4.844-3.305,8.205-3.305
            c3.99,0,7.057,1.833,9.204,5.498c1.31-1.975,2.717-3.385,4.216-4.229c1.502-0.847,3.353-1.269,5.557-1.269
            c3.496,0,6.172,1.102,8.036,3.305c1.861,2.203,2.793,5.376,2.793,9.518v27.041h-11.571V39.013c0-1.255-0.099-2.086-0.297-2.495
            c-0.2-0.408-0.604-0.613-1.212-0.613c-1.14,0-1.709,0.969-1.709,2.906v25.503h-11.569V39.013c0-1.235-0.105-2.063-0.313-2.48
            c-0.208-0.418-0.618-0.627-1.225-0.627c-1.141,0-1.71,1.036-1.71,3.107v25.302H98.375z"
      />
      <path
        style={makeJumpy(4)}
        fill="#6DBE45"
        d="M155.153,35.307c4.026,0,7.479,1.447,10.358,4.346c2.876,2.896,4.314,6.368,4.314,10.414
            c0,4.104-1.457,7.599-4.373,10.486c-2.916,2.887-6.435,4.33-10.558,4.33c-4.122,0-7.646-1.448-10.57-4.345
            c-2.926-2.896-4.388-6.387-4.388-10.472c0-4.16,1.462-7.66,4.388-10.499C147.25,36.728,150.859,35.307,155.153,35.307z
             M154.867,45.821c-1.14,0-2.108,0.413-2.905,1.239c-0.799,0.827-1.197,1.839-1.197,3.036c0,1.176,0.403,2.183,1.21,3.019
            c0.808,0.836,1.772,1.254,2.893,1.254c1.139,0,2.112-0.418,2.921-1.254c0.808-0.836,1.21-1.843,1.21-3.019
            c0-1.197-0.398-2.209-1.194-3.036C157.004,46.234,156.026,45.821,154.867,45.821z"
      />
      <path
        style={makeJumpy(5)}
        fill="#6DBE45"
        d="M183.665,35.307c4.026,0,7.48,1.447,10.358,4.346c2.877,2.896,4.316,6.368,4.316,10.414
            c0,4.104-1.458,7.599-4.375,10.486c-2.916,2.887-6.435,4.33-10.558,4.33c-4.122,0-7.645-1.448-10.57-4.345
            c-2.927-2.896-4.388-6.387-4.388-10.472c0-4.16,1.461-7.66,4.388-10.499C175.763,36.728,179.371,35.307,183.665,35.307z
             M183.38,45.821c-1.142,0-2.109,0.413-2.907,1.239c-0.797,0.827-1.196,1.839-1.196,3.036c0,1.176,0.403,2.183,1.212,3.019
            c0.806,0.836,1.771,1.254,2.892,1.254c1.141,0,2.112-0.418,2.921-1.254c0.807-0.836,1.211-1.843,1.211-3.019
            c0-1.197-0.399-2.209-1.196-3.036C185.518,46.234,184.537,45.821,183.38,45.821z"
      />
      <path
        style={makeJumpy(6)}
        fill="#6DBE45"
        d="M216.508,36.304v11.227c-1.502,0-2.531,0.281-3.093,0.841c-0.561,0.56-0.916,1.665-1.067,3.318
            c-0.494,5.49-2.621,9.365-6.383,11.625c-1.994,1.179-4.826,1.769-8.492,1.769h-1.479V53.8h0.484c1.708,0,2.929-0.355,3.66-1.069
            c0.731-0.712,1.155-1.96,1.269-3.747c0.151-2.905,0.421-4.948,0.813-6.125c0.389-1.179,1.182-2.347,2.38-3.505
            c2.089-2.032,4.984-3.05,8.689-3.05H216.508z"
      />
      <path
        style={makeJumpy(7)}
        fill="#6DBE45"
        d="M243.822,51.834h-16.153c-0.25-0.816-0.373-1.567-0.373-2.252c0-0.948,0.171-1.881,0.513-2.792h5.414
            c-0.379-2.108-1.566-3.163-3.563-3.163c-1.327,0-2.411,0.565-3.247,1.695c-0.837,1.131-1.254,2.579-1.254,4.346
            c0,1.844,0.404,3.334,1.211,4.474c0.808,1.14,1.868,1.709,3.178,1.709c1.063,0,2.09-0.531,3.077-1.595l6.069,7.294
            c-2.832,2.222-5.976,3.333-9.433,3.333c-4.216,0-7.759-1.414-10.627-4.246c-2.871-2.829-4.303-6.333-4.303-10.514
            c0-4.16,1.449-7.674,4.346-10.542c2.896-2.867,6.454-4.303,10.671-4.303c4.12,0,7.583,1.4,10.386,4.202
            c2.802,2.804,4.203,6.256,4.203,10.358C243.938,50.256,243.898,50.922,243.822,51.834z"
      />
      <path
        style={makeJumpy(8)}
        fill="#6DBE45"
        d="M142.262,22.204c0,0,11.446-8.093,12.433-8.702c0.993-0.613-3.828-9.418-6.112-7.892
            c-2.161,1.446,3.353,6.896,1.939,7.746c-1.679,1.008-3.501-4.074-4.976-3.03c-2.066,1.46,2.462,4.985,1.164,5.902
            c-1.651,1.168-2.505-2.567-3.756-1.681c-1.473,1.042,1.255,3.073,0.527,3.875c-1.343,1.479-4.003,2.474-4.003,2.474L142.262,22.204
            z"
      />
      <path
        style={makeJumpy(9)}
        fill="#6DBE45"
        d="M137.286,24.129c0,0-20.564-5.052-22.287-5.364c-1.735-0.312,0.177-15.354,4.23-14.47
            c3.839,0.836-0.902,11.544,1.557,11.959c2.915,0.491,2.67-7.662,5.321-7.01c3.711,0.913-0.708,8.368,1.623,8.942
            c2.971,0.729,2.103-4.994,4.353-4.441c2.648,0.653-0.069,5.014,1.398,5.74c2.706,1.339,6.995,1.269,6.995,1.269L137.286,24.129z"
      />
      <path
        style={makeJumpy(10)}
        fillRule="evenodd"
        clipRule="evenodd"
        fill="#6DBE45"
        d="M145.819,29.292c4.229-1.415,9.412,0.287,12.156-2.098
            c-0.333-7.493-9.489-6.159-15.93-7.545c2.828-1.228-0.533-0.215-3.235,0.702c-4.113-0.979-11.995,6.02-10.177,6.424
            c2.431,0.194,1.318,3.724,0.877,4.344c3.299,3.083,5.748,6.108,10.033,7.096C139.855,37.033,145.588,30.554,145.819,29.292z"
      />
    </g>
  </svg>
);

Logo.defaultProps = {
  logoDark: "#2E7B3C",
};

export default Logo;
