/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2016-2017 Dan "Ducky" Little
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/** React.Component for rendering a toolbar!
 *
 */

import React from "react";
import PropTypes from "prop-types";

import ToolbarButton from "./button";
import { useTranslation } from "react-i18next";

const ToolbarDrawer = ({ label, tip, tools, services }) => {
  const { t } = useTranslation();
  const drawerLabel = t(label);
  const drawerTip = !!tip ? t(tip) : drawerLabel;
  return (
    <div className="drawer">
      <button className="drawer tool" title={drawerTip}>
        <span className="drawer icon"></span>
        <span className="label">{drawerLabel}</span>
      </button>
      <div className="drawer-contents">
        {tools.map((tool, i) => {
          return (
            <ToolbarButton
              key={`btn${i}`}
              tool={tool}
              serviceDef={
                tool.actionType === "service" ? services[tool.name] : undefined
              }
            />
          );
        })}
      </div>
    </div>
  );
};

ToolbarDrawer.defaultProps = {
  label: "Unititled drawer",
  tip: "",
  tools: [],
};

ToolbarDrawer.propTypes = {
  label: PropTypes.string,
  tip: PropTypes.string,
  tools: PropTypes.array,
};

export default ToolbarDrawer;
